<?php include 'partials/html.php' ?>

<head>
    <?php $title = "Search Results"; include 'partials/title-meta.php' ?>

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include 'partials/menu.php' ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">

            <div class="container-fluid">
                
                <?php $subtitle = "Pages"; $title = "Search Results"; include 'partials/page-title.php' ?>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-block">
                                <div class="text-center w-md-75 w-xl-50 mx-auto py-3">
                                    <div class="app-search app-search-pill input-group mb-3 rounded-pill">
                                        <input type="text" class="form-control bg-light-subtle border-light py-2 fw-semibold" value="React Dashboard" placeholder="Search templates...">
                                        <i data-lucide="search" class="app-search-icon text-muted"></i>
                                        <button class="btn btn-secondary" type="button">Explore</button>
                                    </div>
                                    <div class="d-flex justify-content-center align-items-center gap-1">
                                        <h5 class="text-muted mb-0">Popular Searches :</h5>
                                        <a href="#!" class="badge bg-primary-subtle text-primary rounded-pill px-2 py-1 fs-6">Analytics</a>
                                        <a href="#!" class="badge bg-primary-subtle text-primary rounded-pill px-2 py-1 fs-6">SaaS</a>
                                        <a href="#!" class="badge bg-primary-subtle text-primary rounded-pill px-2 py-1 fs-6">Ecommerce</a>
                                        <a href="#!" class="badge bg-primary-subtle text-primary rounded-pill px-2 py-1 fs-6">CRM</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card-header border-light justify-content-between">
                                <h4 class="fst-italic text-muted mb-0">
                                    Found <span class="fw-bold badge badge-soft-danger">89</span> results for <span class="text-dark">"React Dashboard"</span>
                                </h4>
                            
                                <div class="d-flex flex-wrap align-items-center gap-3">
                                    <span class="fw-semibold">Filter By:</span>
                            
                                    <!-- Template Type Filter -->
                                    <div class="app-search">
                                        <select class="form-select form-control my-1 my-md-0">
                                            <option selected>Template Type</option>
                                            <option value="admin">Admin</option>
                                            <option value="landing">Landing Page</option>
                                            <option value="dashboard">Dashboard</option>
                                            <option value="ecommerce">eCommerce</option>
                                            <option value="email">Email Template</option>
                                        </select>
                                        <i data-lucide="layers" class="app-search-icon text-muted"></i>
                                    </div>
                            
                                    <!-- Pricing Filter -->
                                    <div class="app-search">
                                        <select class="form-select form-control my-1 my-md-0">
                                            <option selected>Pricing</option>
                                            <option value="free">Free</option>
                                            <option value="premium">Premium</option>
                                            <option value="subscription">Subscription</option>
                                        </select>
                                        <i data-lucide="circle-dollar-sign" class="app-search-icon text-muted"></i>
                                    </div>
                                </div>
                            </div>                            
                            
                            <div class="card-body p-0">
                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-1">
                                        <a href="https://wrapbootstrap.com/theme/inspinia-multipurpose-admin-dashboard-template-WB0R5L90S?ref=inspinia" target="_blank" class="text-reset">
                                            INSPINIA - Multipurpose Admin Dashboard Template
                                        </a>
                                    </h4>
                                    <p class="text-success mb-2">
                                        https://wrapbootstrap.com/theme/inspinia-multipurpose-admin-dashboard-template-WB0R5L90S?ref=inspinia
                                    </p>
                                    <p class="text-muted mb-2">
                                        INSPINIA is a premium admin dashboard template built with <span class="fw-semibold">Bootstrap</span>. It offers a wide range of UI components, layouts, and features for building modern web apps like CRMs, SaaS dashboards, and admin panels.
                                    </p>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-1 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <img src="assets/images/users/user-4.jpg" alt="avatar-4" class="img-fluid avatar-xs rounded-circle">
                                            <a href="#!" class="link-reset fw-semibold">WebAppLayers</a>
                                        </span>
                                        <span><i class="ti ti-calendar"></i> Published on: Feb 1, 2025</span>
                                        <span><i class="ti ti-shopping-cart"></i> Sales: 1,238</span>
                                        <span><i class="ti ti-message-circle"></i> <a href="#!" class="link-reset">Comments: 54</a></span>
                                        <span><i class="ti ti-thumb-up"></i> Likes: 892</span>
                                    </p>                                                                
                                </div>

                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-1">
                                        <a href="https://wrapbootstrap.com/theme/homer-responsive-admin-template-WB055J451?ref=inspinia" target="_blank" class="text-reset">
                                            Homer - Responsive Admin Theme
                                        </a>
                                    </h4>
                                    <p class="text-success mb-2">
                                        https://wrapbootstrap.com/theme/homer-responsive-admin-template-WB055J451?ref=inspinia
                                    </p>
                                    <p class="text-muted mb-2">
                                        Homer is a clean and fully responsive admin dashboard built with <span class="fw-semibold">Bootstrap</span>. It features a modern design, modular structure, and reusable UI components, making it ideal for analytics dashboards, CRM systems, and custom backend solutions.
                                    </p>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-1 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <img src="assets/images/users/user-5.jpg" alt="avatar-5" class="img-fluid avatar-xs rounded-circle">
                                            <a href="#!" class="link-reset fw-semibold">WebAppLayers</a>
                                        </span>
                                        <span><i class="ti ti-calendar"></i> Published on: Jan 20, 2025</span>
                                        <span><i class="ti ti-shopping-cart"></i> Sales: 978</span>
                                        <span><i class="ti ti-message-circle"></i> <a href="#!" class="link-reset">Comments: 37</a></span>
                                        <span><i class="ti ti-thumb-up"></i> Likes: 765</span>
                                    </p>                                                                
                                </div>

                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-1">
                                        <a href="https://wrapbootstrap.com/theme/luna-responsive-admin-dashboard-template-WB0J69TPB?ref=inspinia" target="_blank" class="text-reset">
                                            LUNA - Responsive Admin Theme
                                        </a>
                                    </h4>
                                    <p class="text-success mb-2">
                                        https://wrapbootstrap.com/theme/luna-responsive-admin-dashboard-template-WB0J69TPB?ref=inspinia
                                    </p>
                                    <p class="text-muted mb-2">
                                        LUNA is a stylish and responsive admin theme built with <span class="fw-semibold">Bootstrap</span>. It includes clean layouts, powerful UI elements, and a lightweight structure—perfect for backend systems, SaaS products, and admin panels.
                                    </p>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-1 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <img src="assets/images/users/user-6.jpg" alt="avatar-6" class="img-fluid avatar-xs rounded-circle">
                                            <a href="#!" class="link-reset fw-semibold">WebAppLayers</a>
                                        </span>
                                        <span><i class="ti ti-calendar"></i> Published on: Dec 12, 2024</span>
                                        <span><i class="ti ti-shopping-cart"></i> Sales: 846</span>
                                        <span><i class="ti ti-message-circle"></i> <a href="#!" class="link-reset">Comments: 42</a></span>
                                        <span><i class="ti ti-thumb-up"></i> Likes: 683</span>
                                    </p>                                                                
                                </div>    
                                
                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-3">
                                        Found some users:
                                    </h4>

                                    <div class="d-flex gap-2">
                                        <div class="avatar">
                                            <img src="assets/images/users/user-4.jpg" alt="" class="rounded avatar-xl">
                                        </div>
                                        <div class="avatar">
                                            <img src="assets/images/users/user-5.jpg" alt="" class="rounded avatar-xl">
                                        </div>
                                        <div class="avatar">
                                            <img src="assets/images/users/user-3.jpg" alt="" class="rounded avatar-xl">
                                        </div>
                                        <div class="avatar">
                                            <img src="assets/images/users/user-8.jpg" alt="" class="rounded avatar-xl">
                                        </div>
                                        <div class="avatar">
                                            <img src="assets/images/users/user-2.jpg" alt="" class="rounded avatar-xl">
                                        </div>
                                    </div>                                                        
                                </div>    

                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-1">
                                        <a href="https://wrapbootstrap.com/theme/homer-responsive-admin-template-WB055J451?ref=inspinia" target="_blank" class="text-reset">
                                            Homer - Responsive Admin Theme
                                        </a>
                                    </h4>
                                    <p class="text-success mb-2">
                                        https://wrapbootstrap.com/theme/homer-responsive-admin-template-WB055J451?ref=inspinia
                                    </p>
                                    <p class="text-muted mb-2">
                                        Homer is a clean and fully responsive admin dashboard built with <span class="fw-semibold">Bootstrap</span>. It features a modern design, modular structure, and reusable UI components, making it ideal for analytics dashboards, CRM systems, and custom backend solutions.
                                    </p>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-1 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <img src="assets/images/users/user-5.jpg" alt="avatar-5" class="img-fluid avatar-xs rounded-circle">
                                            <a href="#!" class="link-reset fw-semibold">WebAppLayers</a>
                                        </span>
                                        <span><i class="ti ti-calendar"></i> Published on: Jan 20, 2025</span>
                                        <span><i class="ti ti-shopping-cart"></i> Sales: 978</span>
                                        <span><i class="ti ti-message-circle"></i> <a href="#!" class="link-reset">Comments: 37</a></span>
                                        <span><i class="ti ti-thumb-up"></i> Likes: 765</span>
                                    </p>                                                                
                                </div>

                                <div class="border-bottom border-dashed px-4 py-3">
                                    <h4 class="fs-md mb-3">
                                        People also search for:
                                    </h4>

                                    <div class="d-flex gap-2 flex-wrap">
                                        <div class="px-3 py-2 bg-light bg-opacity-50 rounded">
                                            <a href="#!" class="text-reset fs-md fw-semibold">Minimal Admin Templates <i class="ti ti-search ms-2"></i></a>
                                        </div>
                                        <div class="px-3 py-2 bg-light bg-opacity-50 rounded">
                                            <a href="#!" class="text-reset fs-md fw-semibold">Bootstrap 5 Admin Panels <i class="ti ti-search ms-2"></i></a>
                                        </div>
                                        <div class="px-3 py-2 bg-light bg-opacity-50 rounded">
                                            <a href="#!" class="text-reset fs-md fw-semibold">SaaS Dashboard UI Kits <i class="ti ti-search ms-2"></i></a>
                                        </div>
                                        <div class="px-3 py-2 bg-light bg-opacity-50 rounded">
                                            <a href="#!" class="text-reset fs-md fw-semibold">Dark Mode Admin Themes <i class="ti ti-search ms-2"></i></a>
                                        </div>
                                    </div>                                                           
                                </div>

                                <ul class="pagination pagination-rounded pagination-boxed justify-content-center mb-0 py-3">
                                    <li class="page-item previous disabled"><a href="#" class="page-link"><i class="ti ti-chevron-left"></i></a></li>
                                    <li class="page-item active"><a href="#" class="page-link">1</a></li>
                                    <li class="page-item"><a href="#" class="page-link">2</a></li>
                                    <li class="page-item "><a href="#" class="page-link">3</a></li>
                                    <li class="page-item "><a href="#" class="page-link">...</a></li>
                                    <li class="page-item "><a href="#" class="page-link">5</a></li>
                                    <li class="page-item "><a href="#" class="page-link">6</a></li>
                                    <li class="page-item next"><a href="#" class="page-link"><i class="ti ti-chevron-right"></i></a></li>
                                </ul>
                                                              
                                
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div> <!-- end col-->
                </div> <!-- end row-->

            </div>
            <!-- container -->

            <?php include 'partials/footer.php' ?>

        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include 'partials/customizer.php' ?>

    <?php include 'partials/footer-scripts.php' ?>

</body>

</html>