<?php include 'partials/html.php' ?>

<head>
    <?php $title = "Form Validation"; include 'partials/title-meta.php' ?>

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include 'partials/menu.php' ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">

            <div class="container-fluid">
                <?php $subtitle = "Forms"; $title = "Validation"; include 'partials/page-title.php' ?>
            </div>

            <div class="container">

                <div class="row">
                    <div class="col-lg-12">

                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Custom styles Validation</h4>
                                <a href="https://getbootstrap.com/docs/5.3/forms/validation/#custom-styles" target="_blank" class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold">View Docs <i class="ti ti-arrow-right bi align-middle fs-lg"></i></a>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate>
                                    <div class="col-md-4">
                                        <label for="validationCustom01" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="validationCustom01" value="John" required>
                                        <div class="valid-feedback">
                                            Looks great!
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationCustom02" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="validationCustom02" value="Doe" required>
                                        <div class="valid-feedback">
                                            Looks great!
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationCustomUsername" class="form-label">Username</label>
                                        <div class="input-group has-validation">
                                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                                            <input type="text" class="form-control" id="validationCustomUsername" placeholder="johndoe123" aria-describedby="inputGroupPrepend" required>
                                            <div class="invalid-feedback">
                                                Please choose a valid username.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">City</label>
                                        <input type="text" class="form-control" id="validationCustom03" placeholder="San Francisco" required>
                                        <div class="invalid-feedback">
                                            Please provide a valid city name.
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationCustom04" class="form-label">State</label>
                                        <select class="form-select" id="validationCustom04" required>
                                            <option selected disabled value="">Choose...</option>
                                            <option>California</option>
                                            <option>Texas</option>
                                            <option>New York</option>
                                            <option>Florida</option>
                                        </select>
                                        <div class="invalid-feedback">
                                            Please select your state.
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationCustom05" class="form-label">Zip Code</label>
                                        <input type="text" class="form-control" id="validationCustom05" placeholder="94107" required>
                                        <div class="invalid-feedback">
                                            Please enter a valid zip code.
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="" id="invalidCheck" required>
                                            <label class="form-check-label" for="invalidCheck">
                                                I agree to the terms and conditions
                                            </label>
                                            <div class="invalid-feedback">
                                                You must agree before submitting.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->

                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Tooltips</h4>
                                <a href="https://getbootstrap.com/docs/5.3/forms/validation/#tooltips" target="_blank" class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold">View Docs <i class="ti ti-arrow-right bi align-middle fs-lg"></i></a>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate>
                                    <div class="col-md-4 position-relative">
                                        <label for="studentFirstName" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="studentFirstName" value="Emily" required>
                                        <div class="valid-tooltip">
                                            Looks good!
                                        </div>
                                    </div>
                                    <div class="col-md-4 position-relative">
                                        <label for="studentLastName" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="studentLastName" value="Chen" required>
                                        <div class="valid-tooltip">
                                            Looks good!
                                        </div>
                                    </div>
                                    <div class="col-md-4 position-relative">
                                        <label for="studentID" class="form-label">Stanford ID</label>
                                        <div class="input-group has-validation">
                                            <span class="input-group-text" id="studentIDPrepend">SU</span>
                                            <input type="text" class="form-control" id="studentID" aria-describedby="studentIDPrepend" placeholder="SU1234567" required>
                                            <div class="invalid-tooltip">
                                                Please enter a valid Stanford ID.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 position-relative">
                                        <label for="studentCity" class="form-label">City</label>
                                        <input type="text" class="form-control" id="studentCity" value="Palo Alto" required>
                                        <div class="invalid-tooltip">
                                            Please provide a valid city.
                                        </div>
                                    </div>
                                    <div class="col-md-3 position-relative">
                                        <label for="studentDepartment" class="form-label">Department</label>
                                        <select class="form-select" id="studentDepartment" required>
                                            <option selected disabled value="">Choose...</option>
                                            <option>Computer Science</option>
                                            <option>Engineering</option>
                                            <option>Biology</option>
                                            <option>Economics</option>
                                            <option>Psychology</option>
                                        </select>
                                        <div class="invalid-tooltip">
                                            Please select your department.
                                        </div>
                                    </div>
                                    <div class="col-md-3 position-relative">
                                        <label for="studentZip" class="form-label">ZIP Code</label>
                                        <input type="text" class="form-control" id="studentZip" value="94305" required>
                                        <div class="invalid-tooltip">
                                            Please provide a valid ZIP code.
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="" id="agreementCheck" required>
                                            <label class="form-check-label" for="agreementCheck">
                                                I confirm my enrollment at Stanford University.
                                            </label>
                                            <div class="invalid-tooltip">
                                                You must confirm before submitting.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-user-plus me-1"></i> Submit Enrollment
                                        </button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->

                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Server-side </h4>
                                <a href="https://getbootstrap.com/docs/5.3/forms/validation/#server-side" target="_blank" class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold">View Docs <i class="ti ti-arrow-right bi align-middle fs-lg"></i></a>
                            </div>

                            <div class="card-body">
                                <form class="row g-3">
                                    <div class="col-md-4">
                                        <label for="validationServer01" class="form-label">First name</label>
                                        <input type="text" class="form-control is-valid" id="validationServer01" value="Mark" required>
                                        <div class="valid-feedback">
                                            Looks good!
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationServer02" class="form-label">Last name</label>
                                        <input type="text" class="form-control is-valid" id="validationServer02" value="Otto" required>
                                        <div class="valid-feedback">
                                            Looks good!
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationServerUsername" class="form-label">Username</label>
                                        <div class="input-group has-validation">
                                            <span class="input-group-text" id="inputGroupPrepend3">@</span>
                                            <input type="text" class="form-control is-invalid" id="validationServerUsername" aria-describedby="inputGroupPrepend3 validationServerUsernameFeedback" required>
                                            <div id="validationServerUsernameFeedback" class="invalid-feedback">
                                                Please choose a username.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationServer03" class="form-label">City</label>
                                        <input type="text" class="form-control is-invalid" id="validationServer03" aria-describedby="validationServer03Feedback" required>
                                        <div id="validationServer03Feedback" class="invalid-feedback">
                                            Please provide a valid city.
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationServer04" class="form-label">State</label>
                                        <select class="form-select is-invalid" id="validationServer04" aria-describedby="validationServer04Feedback" required>
                                            <option selected disabled value="">Choose...</option>
                                            <option>...</option>
                                        </select>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            Please select a valid state.
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationServer05" class="form-label">Zip</label>
                                        <input type="text" class="form-control is-invalid" id="validationServer05" aria-describedby="validationServer05Feedback" required>
                                        <div id="validationServer05Feedback" class="invalid-feedback">
                                            Please provide a valid zip.
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-check">
                                            <input class="form-check-input is-invalid" type="checkbox" value="" id="invalidCheck3" aria-describedby="invalidCheck3Feedback" required>
                                            <label class="form-check-label" for="invalidCheck3">
                                                Agree to terms and conditions
                                            </label>
                                            <div id="invalidCheck3Feedback" class="invalid-feedback">
                                                You must agree before submitting.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit form</button>
                                    </div>
                                </form>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->

                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Supported Elements</h4>
                                <a href="https://getbootstrap.com/docs/5.3/forms/validation/#supported-elements" target="_blank" class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold">View Docs <i class="ti ti-arrow-right bi align-middle fs-lg"></i></a>
                            </div>

                            <div class="card-body">
                                <form class="was-validated">
                                    <div class="mb-3">
                                        <label for="validationTextarea" class="form-label">Textarea</label>
                                        <textarea class="form-control" id="validationTextarea" placeholder="Required example textarea" required></textarea>
                                        <div class="invalid-feedback">
                                            Please enter a message in the textarea.
                                        </div>
                                    </div>

                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" id="validationFormCheck1" required>
                                        <label class="form-check-label" for="validationFormCheck1">Check this checkbox</label>
                                        <div class="invalid-feedback">Example invalid feedback text</div>
                                    </div>

                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" id="validationFormCheck2" name="radio-stacked" required>
                                        <label class="form-check-label" for="validationFormCheck2">Toggle this radio</label>
                                    </div>
                                    <div class="form-check mb-3">
                                        <input type="radio" class="form-check-input" id="validationFormCheck3" name="radio-stacked" required>
                                        <label class="form-check-label" for="validationFormCheck3">Or toggle this other radio</label>
                                        <div class="invalid-feedback">More example invalid feedback text</div>
                                    </div>

                                    <div class="mb-3">
                                        <select class="form-select" required aria-label="select example">
                                            <option value="">Open this select menu</option>
                                            <option value="1">One</option>
                                            <option value="2">Two</option>
                                            <option value="3">Three</option>
                                        </select>
                                        <div class="invalid-feedback">Example invalid select feedback</div>
                                    </div>

                                    <div class="mb-3">
                                        <input type="file" class="form-control" aria-label="file example" required>
                                        <div class="invalid-feedback">Example invalid form file feedback</div>
                                    </div>

                                    <div>
                                        <button class="btn btn-primary" type="submit" disabled>Submit form</button>
                                    </div>
                                </form>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->

                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Browser Defaults</h4>
                                <a href="https://getbootstrap.com/docs/5.3/forms/validation/#browser-defaults" target="_blank" class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold">View Docs <i class="ti ti-arrow-right bi align-middle fs-lg"></i></a>
                            </div>

                            <div class="card-body">
                                <form class="row g-3">
                                    <div class="col-md-4">
                                        <label for="validationDefault01" class="form-label">First name</label>
                                        <input type="text" class="form-control" id="validationDefault01" value="Mark" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationDefault02" class="form-label">Last name</label>
                                        <input type="text" class="form-control" id="validationDefault02" value="Otto" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="validationDefaultUsername" class="form-label">Username</label>
                                        <div class="input-group">
                                            <span class="input-group-text" id="inputGroupPrepend2">@</span>
                                            <input type="text" class="form-control" id="validationDefaultUsername" aria-describedby="inputGroupPrepend2" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationDefault03" class="form-label">City</label>
                                        <input type="text" class="form-control" id="validationDefault03" required>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationDefault04" class="form-label">State</label>
                                        <select class="form-select" id="validationDefault04" required>
                                            <option selected disabled value="">Choose...</option>
                                            <option>...</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="validationDefault05" class="form-label">Zip</label>
                                        <input type="text" class="form-control" id="validationDefault05" required>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="" id="invalidCheck2" required>
                                            <label class="form-check-label" for="invalidCheck2">
                                                Agree to terms and conditions
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit form</button>
                                    </div>
                                </form>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div> <!-- end col-->
                </div> <!-- end row -->

            </div> <!-- container -->

            <?php include 'partials/footer.php' ?>

        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include 'partials/customizer.php' ?>

    <?php include 'partials/footer-scripts.php' ?>

</body>

</html>