@extends('layouts.base', ['title' => 'Landing'])

@section('body_attribute')
class="bg-body-secondary" data-bs-spy="scroll" data-bs-target="#navbar-example"
@endsection

@section('content')

 <!-- Top Alert -->
 <div class="alert alert-primary top-alert text-center mb-0 rounded-0 alert-dismissible" role="alert">
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
    <div class="fst-italic fw-medium">🚀 INSPINIA 4.x is here! Now with Bootstrap 5, dark mode, and a refreshed UI. Upgrade today for the best experience! <a href="https://wrapbootstrap.com/theme/inspinia-multipurpose-admin-dashboard-template-WB0R5L90S?ref=inspinia" target="_blank" class="fw-semibold fst-normal text-white text-decoration-underline link-offset-3 ms-2">Buy Now!</a></div>
</div>

<!-- Header START -->
<header>
    <!-- Nav START -->
    <nav class="navbar navbar-expand-lg py-3 sticky-top" id="landing-navbar">
        <div class="container">
            <div class="auth-brand mb-0">
                <a href="/" class="logo-dark">
                    <img src="/images/logo-black.png" alt="dark logo" height="32">
                </a>
                <a href="/" class="logo-light">
                    <img src="/images/logo.png" alt="logo" height="32">
                </a>
            </div>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav fw-medium gap-2 fs-sm mx-auto mt-2 mt-lg-0" id="navbar-example">
                    <li class="nav-item">
                        <a class="nav-link active" href="#hero">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Features</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#plans">Plans</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#reviews">Reviews</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#blog">Blog</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact">Contact</a>
                    </li>
                </ul>

                <div>
                    <button class="btn btn-link btn-icon fw-semibold text-body" type="button" id="theme-toggle"> <i class="ti ti-contrast fs-22"></i> </button>
                    <a href="{{ route('second', ['auth1', 'login'])}}" class="btn btn-link fw-semibold text-body ps-2">SIGN IN</a>
                    <a href="{{ route('second', ['auth1', 'sign-up'])}}" class="btn btn-sm btn-primary">Sign Up</a>
                </div>
            </div> <!-- end .navbar-collapse-->

        </div> <!-- end container-->
    </nav>
    <!-- Nav END -->
</header>
<!-- Header END -->


<!-- =======================
        HERO SECTION
======================= -->
<section class="bg-light bg-opacity-50 border-top border-light position-relative" id="hero">

    <!-- Background Pattern -->
    <div class="position-absolute top-0 start-50 translate-middle-x mt-5">
        <img src="/images/bg-pattern.png" alt="">
    </div>

    <div class="container pt-5 position-relative">
        <!-- Hero Content Row -->
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">

                <!-- Pre Info Text -->
                <span class="fw-semibold text-muted fst-italic">Trusted by 50k+ happy customers</span>

                <!-- Avatar Group -->
                <div class="avatar-group avatar-group-sm justify-content-center mt-2">
                    <div class="avatar">
                        <img src="/images/users/user-7.jpg" alt="Ava Lee" class="avatar-sm rounded-circle">
                    </div>
                    <div class="avatar">
                        <img src="/images/users/user-8.jpg" alt="Ethan King" class="avatar-sm rounded-circle">
                    </div>
                    <div class="avatar">
                        <img src="/images/users/user-9.jpg" alt="Lucas White" class="avatar-sm rounded-circle">
                    </div>
                    <div class="avatar">
                        <img src="/images/users/user-1.jpg" alt="Lucas White" class="avatar-sm rounded-circle">
                    </div>
                    <div class="avatar">
                        <img src="/images/users/user-2.jpg" alt="Lucas White" class="avatar-sm rounded-circle">
                    </div>
                </div>

                <!-- Hero Title -->
                <h1 class="my-4 fs-36 fw-bold lh-base">
                    The #1 <span class="text-primary">Admin Dashboard</span> Template on WrapBootstrap –
                    <span class="fst-italic text-muted">Trusted by Thousands</span>
                </h1>

                <!-- Hero Description -->
                <p class="mb-4 fs-sm text-muted lh-lg">
                    Build powerful, modern web applications with our top-rated Admin Dashboard Template.
                    Designed for performance, flexibility, and ease of customization, it’s the perfect solution
                    for startups, agencies, and enterprise teams.
                </p>

                <!-- Call to Action Buttons -->
                <div class="d-flex gap-1 gap-sm-2 flex-wrap justify-content-center">
                    <a class="btn btn-secondary py-2 fw-semibold" href="#">
                        <i class="ti ti-basket fs-xl me-2"></i>Buy Now!
                    </a>
                    <a class="btn btn-light py-2 fw-semibold" href="https://wrapbootstrap.com/user/WebAppLayers/message" target="_blank">
                        <i class="ti ti-confetti fs-xl me-2"></i>Contact Us
                    </a>
                </div>
            </div>
        </div>

        <!-- Images & Clients Section -->
        <div class="container position-relative">
            <!-- Hero Illustration Image Row -->
            <div class="row">
                <div class="col-md-10 mx-auto position-relative">

                    <!-- Decorative SVG Element -->
                    <figure class="position-absolute top-0 start-0 translate-middle mt-5 opacity-50">
                        <svg width="111" height="170" viewBox="0 0 111 170" fill="#1ab394" xmlns="http://www.w3.org/2000/svg">
                            <path d="M99.2319 7.37436C100.054 7.30936 101.638 15.7474 102.856 26.059C104.147 36.3089 105.01 48.3589 105.287 55.3911C105.778 69.3822 104.459 80.6992 102.753 80.7559C100.986 80.7391 99.5737 69.5262 99.0765 55.6027C98.7941 48.638 98.612 36.5788 98.4807 26.2931C98.3494 16.0074 98.3422 7.43353 99.2319 7.37436Z" />
                            <path d="M80.3888 75.0118C79.555 75.2119 77.8208 71.6599 75.6665 67.4591C73.5063 63.3259 70.8525 58.6057 69.3802 55.9609C66.4471 50.5361 64.4804 45.7392 65.8687 44.6345C67.1836 43.5915 71.6484 47.0394 74.8842 52.8986C76.5416 55.7636 78.7318 61.1241 79.8822 65.9185C81.0327 70.7128 81.2226 74.8118 80.3888 75.0118Z" />
                            <path d="M61.7883 89.4615C61.3805 90.2428 54.8078 87.5652 47.1688 83.8428C39.5297 80.1205 30.9035 75.2241 26.0659 72.1522C16.3908 66.0084 9.53733 59.4962 10.5438 58.0863C11.5502 56.6764 19.903 60.8007 29.4489 66.8652C34.2189 69.9313 42.3932 75.3329 49.4043 80.0217C56.4097 84.7779 62.1902 88.7478 61.7883 89.4615Z" />
                            <path d="M46.1586 113.626C46.0151 114.498 42.6533 114.82 38.7186 114.684C34.7105 114.609 30.1297 114.077 27.4574 113.506C22.1804 112.369 18.3033 109.993 18.7195 108.328C19.1356 106.663 23.5897 106.299 28.7317 107.424C31.2689 107.984 35.6563 109.18 39.43 110.39C43.2037 111.601 46.2962 112.821 46.1586 113.626Z" />
                            <path d="M52.2364 144.838C52.4365 145.672 46.3447 147.663 39.1256 150.101C31.9065 152.538 23.5601 155.423 18.719 157.114C9.04856 160.36 0.851466 162.305 0.169487 160.749C-0.512493 159.193 6.75837 154.583 16.7107 151.225C21.6868 149.545 30.3976 147.169 38.0635 145.858C45.6002 144.469 52.0363 144.005 52.2364 144.838Z" />
                        </svg>
                    </figure>

                    <!-- Hero Main Image -->
                    <img src="/images/dashboard-1.png" class="rounded-top-4 shadow-lg img-fluid mt-5" alt="saas-img">

                </div>
            </div>
        </div>
    </div>
</section>
<!-- =======================
        HERO SECTION END
======================= -->


<!-- =======================
    SERVICES SECTION
======================= -->
<section class="section-custom pb-5" id="services">
    <div class="container">

        <!-- Section Heading -->
        <div class="row">
            <div class="col-12 text-center">
                <span class="text-muted rounded-3 d-inline-block">🚀 Empowering your digital journey</span>
                <h2 class="mt-3 fw-bold mb-5">Discover Our <mark class="fst-italic">Core Services</mark> and Capabilities</h2>
            </div>
        </div>

        <!-- First Row of Service Cards -->
        <div class="row">
            <!-- Digital Strategy Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-bulb"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Digital Strategy</h4>
                        <p class="text-muted mb-3">Crafting data-driven strategies to maximize online growth and brand engagement.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- SEO Optimization Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-chart-bar"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">SEO Optimization</h4>
                        <p class="text-muted mb-3">Improve search engine rankings and increase website visibility through tailored SEO practices.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- Social Media Marketing Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-speakerphone"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Social Media Marketing</h4>
                        <p class="text-muted mb-3">Engage your audience across platforms with strategic content and campaign management.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- Web Development Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-world"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Web Development</h4>
                        <p class="text-muted mb-3">Building fast, responsive, and scalable websites that meet your business needs.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>
        </div> <!-- end row-->

        <!-- Second Row of Service Cards -->
        <div class="row">
            <!-- Email Marketing Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-mail"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Email Marketing</h4>
                        <p class="text-muted mb-3">Connect with your audience and boost conversions through targeted email campaigns.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- E-Commerce Solutions Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-shopping-cart"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">E-Commerce Solutions</h4>
                        <p class="text-muted mb-3">Launch and manage high-performing online stores with secure, scalable features.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- Content Creation Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-camera"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Content Creation</h4>
                        <p class="text-muted mb-3">Produce compelling visuals and copy to drive traffic and build brand identity.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>

            <!-- Security Audits Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 p-2 card-h-100">
                    <div class="card-body pb-0">
                        <div class="avatar-xl mb-3">
                            <span class="avatar-title text-bg-secondary rounded-circle fs-22">
                                <i class="ti ti-shield-check"></i>
                            </span>
                        </div>
                        <h4 class="mb-2">Security Audits</h4>
                        <p class="text-muted mb-3">Ensure your website and data are secure with comprehensive vulnerability assessments.</p>
                    </div>
                    <div class="card-footer border-0 pt-0">
                        <a class="link-primary fw-semibold" href="#">Know more<i class="ti ti-arrow-right ms-2 align-middle"></i></a>
                    </div>
                </div>
            </div>
        </div> <!-- end row-->

    </div> <!-- end container-->
</section>
<!-- =======================
    SERVICES SECTION END
======================= -->

<!-- =======================
    Features SECTION
======================= -->
<section class="section-custom bg-light bg-opacity-30 border-top border-light border-bottom" id="features">
    <div class="container">
        <div class="row align-items-center pb-5">
            <div class="col-lg-6 col-xl-5 py-3">
                <div class="position-relative">
                    <figure class="position-absolute top-0 start-0 translate-middle mt-5 opacity-25">
                        <svg width="111" height="170" viewBox="0 0 111 170" fill="#1ab394" xmlns="http://www.w3.org/2000/svg">
                            <path d="M99.2319 7.37436C100.054 7.30936 101.638 15.7474 102.856 26.059C104.147 36.3089 105.01 48.3589 105.287 55.3911C105.778 69.3822 104.459 80.6992 102.753 80.7559C100.986 80.7391 99.5737 69.5262 99.0765 55.6027C98.7941 48.638 98.612 36.5788 98.4807 26.2931C98.3494 16.0074 98.3422 7.43353 99.2319 7.37436Z" />
                            <path d="M80.3888 75.0118C79.555 75.2119 77.8208 71.6599 75.6665 67.4591C73.5063 63.3259 70.8525 58.6057 69.3802 55.9609C66.4471 50.5361 64.4804 45.7392 65.8687 44.6345C67.1836 43.5915 71.6484 47.0394 74.8842 52.8986C76.5416 55.7636 78.7318 61.1241 79.8822 65.9185C81.0327 70.7128 81.2226 74.8118 80.3888 75.0118Z" />
                            <path d="M61.7883 89.4615C61.3805 90.2428 54.8078 87.5652 47.1688 83.8428C39.5297 80.1205 30.9035 75.2241 26.0659 72.1522C16.3908 66.0084 9.53733 59.4962 10.5438 58.0863C11.5502 56.6764 19.903 60.8007 29.4489 66.8652C34.2189 69.9313 42.3932 75.3329 49.4043 80.0217C56.4097 84.7779 62.1902 88.7478 61.7883 89.4615Z" />
                            <path d="M46.1586 113.626C46.0151 114.498 42.6533 114.82 38.7186 114.684C34.7105 114.609 30.1297 114.077 27.4574 113.506C22.1804 112.369 18.3033 109.993 18.7195 108.328C19.1356 106.663 23.5897 106.299 28.7317 107.424C31.2689 107.984 35.6563 109.18 39.43 110.39C43.2037 111.601 46.2962 112.821 46.1586 113.626Z" />
                            <path d="M52.2364 144.838C52.4365 145.672 46.3447 147.663 39.1256 150.101C31.9065 152.538 23.5601 155.423 18.719 157.114C9.04856 160.36 0.851466 162.305 0.169487 160.749C-0.512493 159.193 6.75837 154.583 16.7107 151.225C21.6868 149.545 30.3976 147.169 38.0635 145.858C45.6002 144.469 52.0363 144.005 52.2364 144.838Z" />
                        </svg>
                    </figure>

                    <!-- Main image -->
                    <img src="/images/chat.png" class="rounded-3 shadow-lg img-fluid mt-5 z-1 position-relative" alt="saas-img">

                    <figure class="position-absolute bottom-0 end-0 me-n5 mb-n5 opacity-25">
                        <svg width="120" height="120" xmlns="http://www.w3.org/2000/svg">
                            <g fill="#1c84c6">
                                <circle cx="10" cy="10" r="4" />
                                <circle cx="26" cy="10" r="4" />
                                <circle cx="42" cy="10" r="4" />
                                <circle cx="58" cy="10" r="4" />
                                <circle cx="74" cy="10" r="4" />
                                <circle cx="90" cy="10" r="4" />

                                <!-- Row 1 -->
                                <circle cx="10" cy="26" r="4" />
                                <circle cx="26" cy="26" r="4" />
                                <circle cx="42" cy="26" r="4" />
                                <circle cx="58" cy="26" r="4" />
                                <circle cx="74" cy="26" r="4" />
                                <circle cx="90" cy="26" r="4" />

                                <!-- Row 2 -->
                                <circle cx="10" cy="42" r="4" />
                                <circle cx="26" cy="42" r="4" />
                                <circle cx="42" cy="42" r="4" />
                                <circle cx="58" cy="42" r="4" />
                                <circle cx="74" cy="42" r="4" />
                                <circle cx="90" cy="42" r="4" />

                                <!-- Row 3 -->
                                <circle cx="10" cy="58" r="4" />
                                <circle cx="26" cy="58" r="4" />
                                <circle cx="42" cy="58" r="4" />
                                <circle cx="58" cy="58" r="4" />
                                <circle cx="74" cy="58" r="4" />
                                <circle cx="90" cy="58" r="4" />

                                <!-- Row 4 -->
                                <circle cx="10" cy="74" r="4" />
                                <circle cx="26" cy="74" r="4" />
                                <circle cx="42" cy="74" r="4" />
                                <circle cx="58" cy="74" r="4" />
                                <circle cx="74" cy="74" r="4" />
                                <circle cx="90" cy="74" r="4" />

                                <!-- Row 5 -->
                                <circle cx="10" cy="90" r="4" />
                                <circle cx="26" cy="90" r="4" />
                                <circle cx="42" cy="90" r="4" />
                                <circle cx="58" cy="90" r="4" />
                                <circle cx="74" cy="90" r="4" />
                                <circle cx="90" cy="90" r="4" />
                            </g>
                        </svg>
                    </figure>
                </div> <!-- end position relative -->
            </div> <!-- end col-->

            <!-- Content -->
            <div class="col-lg-5 ms-auto py-3">
                <h2 class="mb-4 lh-base">Connecting conversations across the world</h2>
                <p class="mb-2 lead">Fast, secure, and intuitive—our chat platform empowers teams and communities to communicate effortlessly, no matter the distance.</p>
                <p class="text-muted fs-sm mb-4">Experience seamless messaging with built-in privacy features and unmatched reliability.</p>
                <a href="chat" class="btn btn-primary mb-4">Check Chat App</a>

                <!-- Counter -->
                <div class="d-flex flex-wrap justify-content-between gap-4 mt-4">
                    <div>
                        <h3 class="mb-2"><span data-target="99.2">0</span><span class="text-primary">%</span></h3>
                        <p class="text-muted mb-0">User satisfaction</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="7.4">0</span><span class="text-primary">x</span></h3>
                        <p class="text-muted mb-0">Monthly user growth</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="1200">0</span><span class="text-primary">+</span></h3>
                        <p class="text-muted mb-0">Messages sent per second</p>
                    </div>
                </div>
            </div><!-- end col-->
        </div> <!-- end row-->

        <div class="row align-items-center py-5">
            <div class="col-lg-5 py-5 order-2 order-lg-1">
                <h2 class="mb-4 lh-base">Manage your files seamlessly from anywhere</h2>
                <p class="mb-2 lead">A powerful, secure, and intuitive file manager built to simplify how individuals and teams store, share, and organize files.</p>
                <p class="text-muted fs-sm mb-4">Access files instantly, collaborate in real-time, and enjoy peace of mind with encrypted storage.</p>
                <a href="file-manager" class="btn btn-primary mb-4">Explore File Manager</a>

                <!-- Counter -->
                <div class="d-flex flex-wrap justify-content-between gap-4 mt-4">
                    <div>
                        <h3 class="mb-2"><span data-target="99.5">0</span><span class="text-primary">%</span></h3>
                        <p class="text-muted mb-0">File recovery success rate</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="3.2">0</span><span class="text-primary">x</span></h3>
                        <p class="text-muted mb-0">Faster upload speed</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="1500">0</span><span class="text-primary">+</span></h3>
                        <p class="text-muted mb-0">Files organized per minute</p>
                    </div>
                </div>
            </div> <!-- end col-->

            <div class="col-lg-6 col-xl-5 ms-auto py-5 order-1 order-lg-2">
                <div class="position-relative">
                    <figure class="position-absolute top-0 start-0 translate-middle mt-5 opacity-25">
                        <svg width="111" height="170" viewBox="0 0 111 170" fill="#1c84c6" xmlns="http://www.w3.org/2000/svg">
                            <path d="M99.2319 7.37436C100.054 7.30936 101.638 15.7474 102.856 26.059C104.147 36.3089 105.01 48.3589 105.287 55.3911C105.778 69.3822 104.459 80.6992 102.753 80.7559C100.986 80.7391 99.5737 69.5262 99.0765 55.6027C98.7941 48.638 98.612 36.5788 98.4807 26.2931C98.3494 16.0074 98.3422 7.43353 99.2319 7.37436Z" />
                            <path d="M80.3888 75.0118C79.555 75.2119 77.8208 71.6599 75.6665 67.4591C73.5063 63.3259 70.8525 58.6057 69.3802 55.9609C66.4471 50.5361 64.4804 45.7392 65.8687 44.6345C67.1836 43.5915 71.6484 47.0394 74.8842 52.8986C76.5416 55.7636 78.7318 61.1241 79.8822 65.9185C81.0327 70.7128 81.2226 74.8118 80.3888 75.0118Z" />
                            <path d="M61.7883 89.4615C61.3805 90.2428 54.8078 87.5652 47.1688 83.8428C39.5297 80.1205 30.9035 75.2241 26.0659 72.1522C16.3908 66.0084 9.53733 59.4962 10.5438 58.0863C11.5502 56.6764 19.903 60.8007 29.4489 66.8652C34.2189 69.9313 42.3932 75.3329 49.4043 80.0217C56.4097 84.7779 62.1902 88.7478 61.7883 89.4615Z" />
                            <path d="M46.1586 113.626C46.0151 114.498 42.6533 114.82 38.7186 114.684C34.7105 114.609 30.1297 114.077 27.4574 113.506C22.1804 112.369 18.3033 109.993 18.7195 108.328C19.1356 106.663 23.5897 106.299 28.7317 107.424C31.2689 107.984 35.6563 109.18 39.43 110.39C43.2037 111.601 46.2962 112.821 46.1586 113.626Z" />
                            <path d="M52.2364 144.838C52.4365 145.672 46.3447 147.663 39.1256 150.101C31.9065 152.538 23.5601 155.423 18.719 157.114C9.04856 160.36 0.851466 162.305 0.169487 160.749C-0.512493 159.193 6.75837 154.583 16.7107 151.225C21.6868 149.545 30.3976 147.169 38.0635 145.858C45.6002 144.469 52.0363 144.005 52.2364 144.838Z" />
                        </svg>
                    </figure>

                    <!-- Main image -->
                    <img src="/images/file-manager.png" class="rounded-3 shadow-lg img-fluid mt-5 z-1 position-relative" alt="saas-img">

                    <figure class="position-absolute bottom-0 end-0 me-n5 mb-n5 opacity-25">
                        <svg width="120" height="120" xmlns="http://www.w3.org/2000/svg">
                            <g fill="#f8ac59">
                                <circle cx="10" cy="10" r="4" />
                                <circle cx="26" cy="10" r="4" />
                                <circle cx="42" cy="10" r="4" />
                                <circle cx="58" cy="10" r="4" />
                                <circle cx="74" cy="10" r="4" />
                                <circle cx="90" cy="10" r="4" />

                                <!-- Row 1 -->
                                <circle cx="10" cy="26" r="4" />
                                <circle cx="26" cy="26" r="4" />
                                <circle cx="42" cy="26" r="4" />
                                <circle cx="58" cy="26" r="4" />
                                <circle cx="74" cy="26" r="4" />
                                <circle cx="90" cy="26" r="4" />

                                <!-- Row 2 -->
                                <circle cx="10" cy="42" r="4" />
                                <circle cx="26" cy="42" r="4" />
                                <circle cx="42" cy="42" r="4" />
                                <circle cx="58" cy="42" r="4" />
                                <circle cx="74" cy="42" r="4" />
                                <circle cx="90" cy="42" r="4" />

                                <!-- Row 3 -->
                                <circle cx="10" cy="58" r="4" />
                                <circle cx="26" cy="58" r="4" />
                                <circle cx="42" cy="58" r="4" />
                                <circle cx="58" cy="58" r="4" />
                                <circle cx="74" cy="58" r="4" />
                                <circle cx="90" cy="58" r="4" />

                                <!-- Row 4 -->
                                <circle cx="10" cy="74" r="4" />
                                <circle cx="26" cy="74" r="4" />
                                <circle cx="42" cy="74" r="4" />
                                <circle cx="58" cy="74" r="4" />
                                <circle cx="74" cy="74" r="4" />
                                <circle cx="90" cy="74" r="4" />

                                <!-- Row 5 -->
                                <circle cx="10" cy="90" r="4" />
                                <circle cx="26" cy="90" r="4" />
                                <circle cx="42" cy="90" r="4" />
                                <circle cx="58" cy="90" r="4" />
                                <circle cx="74" cy="90" r="4" />
                                <circle cx="90" cy="90" r="4" />
                            </g>
                        </svg>
                    </figure>
                </div> <!-- end .position-relative -->
            </div> <!-- end col-->
        </div> <!-- end row-->

        <div class="row align-items-center py-5">
            <div class="col-lg-6 col-xl-5 py-3">
                <div class="position-relative">
                    <figure class="position-absolute top-0 start-0 translate-middle mt-5 opacity-25">
                        <svg width="111" height="170" viewBox="0 0 111 170" fill="#7b70ef" xmlns="http://www.w3.org/2000/svg">
                            <path d="M99.2319 7.37436C100.054 7.30936 101.638 15.7474 102.856 26.059C104.147 36.3089 105.01 48.3589 105.287 55.3911C105.778 69.3822 104.459 80.6992 102.753 80.7559C100.986 80.7391 99.5737 69.5262 99.0765 55.6027C98.7941 48.638 98.612 36.5788 98.4807 26.2931C98.3494 16.0074 98.3422 7.43353 99.2319 7.37436Z" />
                            <path d="M80.3888 75.0118C79.555 75.2119 77.8208 71.6599 75.6665 67.4591C73.5063 63.3259 70.8525 58.6057 69.3802 55.9609C66.4471 50.5361 64.4804 45.7392 65.8687 44.6345C67.1836 43.5915 71.6484 47.0394 74.8842 52.8986C76.5416 55.7636 78.7318 61.1241 79.8822 65.9185C81.0327 70.7128 81.2226 74.8118 80.3888 75.0118Z" />
                            <path d="M61.7883 89.4615C61.3805 90.2428 54.8078 87.5652 47.1688 83.8428C39.5297 80.1205 30.9035 75.2241 26.0659 72.1522C16.3908 66.0084 9.53733 59.4962 10.5438 58.0863C11.5502 56.6764 19.903 60.8007 29.4489 66.8652C34.2189 69.9313 42.3932 75.3329 49.4043 80.0217C56.4097 84.7779 62.1902 88.7478 61.7883 89.4615Z" />
                            <path d="M46.1586 113.626C46.0151 114.498 42.6533 114.82 38.7186 114.684C34.7105 114.609 30.1297 114.077 27.4574 113.506C22.1804 112.369 18.3033 109.993 18.7195 108.328C19.1356 106.663 23.5897 106.299 28.7317 107.424C31.2689 107.984 35.6563 109.18 39.43 110.39C43.2037 111.601 46.2962 112.821 46.1586 113.626Z" />
                            <path d="M52.2364 144.838C52.4365 145.672 46.3447 147.663 39.1256 150.101C31.9065 152.538 23.5601 155.423 18.719 157.114C9.04856 160.36 0.851466 162.305 0.169487 160.749C-0.512493 159.193 6.75837 154.583 16.7107 151.225C21.6868 149.545 30.3976 147.169 38.0635 145.858C45.6002 144.469 52.0363 144.005 52.2364 144.838Z" />
                        </svg>
                    </figure>

                    <!-- Main image -->
                    <img src="/images/team.png" class="rounded-3 shadow-lg img-fluid mt-5 z-1 position-relative" alt="saas-img">

                    <figure class="position-absolute bottom-0 end-0 me-n5 mb-n5 opacity-25">
                        <svg width="120" height="120" xmlns="http://www.w3.org/2000/svg">
                            <g fill="#ed5565">
                                <circle cx="10" cy="10" r="4" />
                                <circle cx="26" cy="10" r="4" />
                                <circle cx="42" cy="10" r="4" />
                                <circle cx="58" cy="10" r="4" />
                                <circle cx="74" cy="10" r="4" />
                                <circle cx="90" cy="10" r="4" />

                                <!-- Row 1 -->
                                <circle cx="10" cy="26" r="4" />
                                <circle cx="26" cy="26" r="4" />
                                <circle cx="42" cy="26" r="4" />
                                <circle cx="58" cy="26" r="4" />
                                <circle cx="74" cy="26" r="4" />
                                <circle cx="90" cy="26" r="4" />

                                <!-- Row 2 -->
                                <circle cx="10" cy="42" r="4" />
                                <circle cx="26" cy="42" r="4" />
                                <circle cx="42" cy="42" r="4" />
                                <circle cx="58" cy="42" r="4" />
                                <circle cx="74" cy="42" r="4" />
                                <circle cx="90" cy="42" r="4" />

                                <!-- Row 3 -->
                                <circle cx="10" cy="58" r="4" />
                                <circle cx="26" cy="58" r="4" />
                                <circle cx="42" cy="58" r="4" />
                                <circle cx="58" cy="58" r="4" />
                                <circle cx="74" cy="58" r="4" />
                                <circle cx="90" cy="58" r="4" />

                                <!-- Row 4 -->
                                <circle cx="10" cy="74" r="4" />
                                <circle cx="26" cy="74" r="4" />
                                <circle cx="42" cy="74" r="4" />
                                <circle cx="58" cy="74" r="4" />
                                <circle cx="74" cy="74" r="4" />
                                <circle cx="90" cy="74" r="4" />

                                <!-- Row 5 -->
                                <circle cx="10" cy="90" r="4" />
                                <circle cx="26" cy="90" r="4" />
                                <circle cx="42" cy="90" r="4" />
                                <circle cx="58" cy="90" r="4" />
                                <circle cx="74" cy="90" r="4" />
                                <circle cx="90" cy="90" r="4" />
                            </g>
                        </svg>
                    </figure>
                </div>
            </div> <!-- end col-->

            <!-- Content -->
            <div class="col-lg-5 ms-auto py-3">
                <h2 class="mb-4 lh-base">Manage your connections with ease</h2>
                <p class="mb-2 lead">Our smart contacts app keeps all your relationships organized, accessible, and in sync across devices—at home or on the go.</p>
                <p class="text-muted fs-sm mb-4">Effortlessly import, categorize, and interact with contacts through a clean, privacy-focused interface.</p>
                <a href="contacts" class="btn btn-primary mb-4">Check Contacts App</a>

                <!-- Counter -->
                <div class="d-flex flex-wrap justify-content-between gap-4 mt-4">
                    <div>
                        <h3 class="mb-2"><span data-target="97.5">0</span><span class="text-primary">%</span></h3>
                        <p class="text-muted mb-0">Sync reliability</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="4.2">0</span><span class="text-primary">x</span></h3>
                        <p class="text-muted mb-0">Faster contact search</p>
                    </div>

                    <div>
                        <h3 class="mb-2"><span data-target="250000">0</span><span class="text-primary">+</span></h3>
                        <p class="text-muted mb-0">Contacts managed daily</p>
                    </div>
                </div>
            </div> <!-- end col-->
        </div> <!-- end row-->
    </div> <!-- end container-->
</section>
<!-- =======================
    Features SECTION END
======================= -->

<!-- =======================
    PLANS SECTION
======================= -->
<section class="section-custom" id="plans">
    <div class="container">

        <div class="row">
            <div class="col-12 text-center">
                <span class="text-muted rounded-3 d-inline-block">💰 Transparent and flexible pricing</span>
                <h2 class="mt-3 fw-bold mb-5">Choose the <mark class="fst-italic">License</mark> That Fits Your Needs</h2>
            </div>
        </div> <!-- end row-->

        <div class="row justify-content-center">
            <div class="col-xxl-10">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card h-100 bg-light bg-opacity-10 border-light rounded-3">
                            <div class="card-body px-lg-4 p-5 pb-2 text-center">
                                <div class="text-center">
                                    <h3 class="fw-bold mb-1">Single License</h3>
                                    <p class="text-muted mb-0">Perfect for personal or one-client projects</p>
                                </div>
                                <div class="my-4">
                                    <h1 class="display-6 fw-bold mb-0">$49</h1>
                                    <small class="d-block text-muted fs-base fw-medium">One-time payment</small>
                                    <small class="d-block text-muted fw-medium">Single project use</small>
                                </div>

                                <ul class="list-unstyled text-start fs-sm fw-medium mb-0">
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> 1 project usage</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Full component access</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Basic documentation</li>
                                    <li class="mb-2"><i class="ti ti-x text-danger me-2 fs-5"></i> No multi-client use</li>
                                    <li class="mb-2"><i class="ti ti-x text-danger me-2 fs-5"></i> No SaaS/resale rights</li>
                                </ul>
                            </div>
                            <div class="card-footer bg-transparent border-0 px-5 pb-4">
                                <a href="#!" class="btn btn-outline-primary w-100 py-2 fw-semibold rounded-pill">Buy Single License</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card h-100 bg-light bg-opacity-10 border-dashed border my-4 my-lg-0 rounded-3">
                            <div class="card-body px-lg-4 p-5 pb-2 text-center">
                                <div class="text-center">
                                    <h3 class="fw-bold mb-1">Multiple License</h3>
                                    <p class="text-muted mb-0">For developers or agencies working with multiple clients</p>
                                </div>
                                <div class="my-4">
                                    <h1 class="display-6 fw-bold mb-0">$249</h1>
                                    <small class="d-block text-muted fs-base fw-medium">One-time payment</small>
                                    <small class="d-block text-muted fw-medium">Up to 5 projects</small>
                                </div>

                                <ul class="list-unstyled text-start fs-sm fw-medium mb-0">
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Use in up to 5 projects</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Commercial client use</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Lifetime updates</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Premium support</li>
                                    <li class="mb-2"><i class="ti ti-x text-danger me-2 fs-5"></i> No resale/SaaS rights</li>
                                </ul>
                            </div>
                            <div class="card-footer bg-transparent border-0 px-5 pb-4">
                                <a href="#!" class="btn btn-primary w-100 py-2 fw-semibold rounded-pill">Buy Multiple License</a>
                            </div>
                            <span class="position-absolute top-0 start-50 translate-middle-x badge bg-primary-subtle text-primary rounded-pill px-3 py-1 mt-3">
                                Best Value
                            </span>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card h-100 bg-light bg-opacity-10 border-light rounded-3">
                            <div class="card-body px-lg-4 p-5 pb-2 text-center">
                                <div class="text-center">
                                    <h3 class="fw-bold mb-1">Extended License</h3>
                                    <p class="text-muted mb-0">For SaaS products or items offered in paid applications</p>
                                </div>
                                <div class="my-4">
                                    <h1 class="display-6 fw-bold mb-0">$999</h1>
                                    <small class="d-block text-muted fs-base fw-medium">One-time payment</small>
                                    <small class="d-block text-muted fw-medium">Commercial redistribution rights</small>
                                </div>

                                <ul class="list-unstyled text-start fs-sm fw-medium mb-0">
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Unlimited project usage</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> SaaS & resale rights</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Full Figma source files</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Priority support</li>
                                    <li class="mb-2"><i class="ti ti-check text-success me-2 fs-5"></i> Custom licensing agreement</li>
                                </ul>
                            </div>
                            <div class="card-footer bg-transparent border-0 px-5 pb-4">
                                <a href="#!" class="btn btn-dark w-100 py-2 fw-semibold rounded-pill">Buy Extended License</a>
                            </div>
                        </div>
                    </div> <!-- end col-->
                </div> <!-- end row-->

            </div> <!-- end col-->
        </div> <!-- end row-->
    </div> <!-- end container-->
</section>
<!-- =======================
    PLANS SECTION END
======================= -->

<!-- =======================
    CTA SECTION
======================= -->

<section>
    <div class="section-cta position-relative card-side-img overflow-hidden" style="background-image: url(/images/landing-cta.jpg);">
        <div class="card-img-overlay d-flex align-items-center flex-column gap-3 justify-content-center auth-overlay text-center">
            <h3 class="text-white fs-24 mb-0 fw-bold">
                Build Faster with Our Premium Admin Template
            </h3>
            <p class="text-white text-opacity-75 fs-md">
                Kickstart your project with a modern, responsive, and developer-friendly admin dashboard. <br> Try it free for 14 days — no credit card needed.
            </p>
            <a href="#!" class="btn btn-light rounded-pill">Buy Our Template</a>
        </div>
    </div>
</section>

<!-- =======================
    CTA SECTION END
======================= -->

<!-- =======================
    REVIEWS SECTION
======================= -->
<section class="section-custom position-relative overflow-hidden" id="reviews">

    <!-- background pattern -->
    <div class="position-absolute top-0 start-50 translate-middle-x mt-5 opacity-50">
        <img src="/images/bg-pattern.png" alt="">
    </div>

    <div class="container position-relative">

        <div class="row">
            <div class="col-12 text-center">
                <span class="text-muted rounded-3 d-inline-block">💬 What Our Customers Are Saying</span>
                <h2 class="mt-3 fw-bold mb-5">Real Feedback from <mark class="fst-italic">Satisfied</mark> Clients</h2>
            </div>
        </div> <!-- end row-->

        <div class="row justify-content-center">
            <div class="col-lg-4">
                <div class="card border-light rounded-4 p-3 card-h-100">
                    <div class="card-body pb-0 text-center">
                        <div class="avatar avatar-xl mx-auto mb-3">
                            <img src="/images/users/user-1.jpg" alt="Emily Carter" class="img-fluid rounded-circle">
                        </div>
                        <span class="text-warning fs-lg mb-3 d-block">
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                        </span>
                        <h4 class="mb-2 fs-md">Absolutely love it!</h4>
                        <p class="text-muted mb-3 fst-italic fs-sm">"This gadget exceeded all my expectations. Sleek design and incredible performance!"</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card border-light rounded-4 p-3 card-h-100">
                    <div class="card-body pb-0 text-center">
                        <div class="avatar avatar-xl mx-auto mb-3">
                            <img src="/images/users/user-2.jpg" alt="Michael Zhang" class="img-fluid rounded-circle">
                        </div>
                        <span class="text-warning fs-lg mb-3 d-block">
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                        </span>
                        <h4 class="mb-2 fs-md">Great value for money</h4>
                        <p class="text-muted mb-3 fst-italic fs-sm">"Sturdy build and long battery life. Would definitely recommend it to friends!"</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card border-light rounded-4 p-3 card-h-100">
                    <div class="card-body pb-0 text-center">
                        <div class="avatar avatar-xl mx-auto mb-3">
                            <img src="/images/users/user-3.jpg" alt="Sara Lopez" class="img-fluid rounded-circle">
                        </div>
                        <span class="text-warning fs-lg mb-3 d-block">
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                        </span>
                        <h4 class="mb-2 fs-md">Top-notch customer service</h4>
                        <p class="text-muted mb-3 fst-italic fs-sm">"The team helped me with my issue right away. Smooth experience overall!"</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card border-light rounded-4 p-3 card-h-100">
                    <div class="card-body pb-0 text-center">
                        <div class="avatar avatar-xl mx-auto mb-3">
                            <img src="/images/users/user-4.jpg" alt="James Whitman" class="img-fluid rounded-circle">
                        </div>
                        <span class="text-warning fs-lg mb-3 d-block">
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                        </span>
                        <h4 class="mb-2 fs-md">Highly impressed</h4>
                        <p class="text-muted mb-3 fst-italic fs-sm">"The performance and features are unmatched in this price range. Highly impressed!"</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card border-light rounded-4 p-3 card-h-100">
                    <div class="card-body pb-0 text-center">
                        <div class="avatar avatar-xl mx-auto mb-3">
                            <img src="/images/users/user-5.jpg" alt="Aisha Khan" class="img-fluid rounded-circle">
                        </div>
                        <span class="text-warning fs-lg mb-3 d-block">
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                            <span class="ti ti-star-filled"></span>
                        </span>
                        <h4 class="mb-2 fs-md">Smooth experience from start to finish</h4>
                        <p class="text-muted mb-3 fst-italic fs-sm">"The website, shipping, and support all worked flawlessly. Very satisfied!"</p>
                    </div>
                </div>
            </div>
        </div> <!-- end row-->

        <div class="row justify-content-center mt-5">
            <div class="col-xxl-9">
                <div class="d-flex justify-content-center align-items-center flex-wrap gap-5 mt-4">
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/01.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/02.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/03.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/04.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/05.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/06.svg" alt="logo" height="42">
                        </a>
                    </div>
                    <div>
                        <a href="#!" class="d-block">
                            <img src="/images/clients/07.svg" alt="logo" height="42">
                        </a>
                    </div>
                </div>
            </div>
        </div> <!-- end row-->
    </div> <!-- end container-->
</section>
<!-- =======================
    REVIEWS SECTION END
======================= -->

<!-- =======================
    BLOG SECTION
======================= -->
<section class="section-custom bg-light bg-opacity-30 border-top border-bottom border-light" id="blog">

    <div class="container">

        <div class="row">
            <div class="col-12 text-center">
                <span class="text-muted rounded-3 d-inline-block">📝 Insights & Resources</span>
                <h2 class="mt-3 fw-bold mb-5">Explore Our <mark class="fst-italic">Latest</mark> Articles and Updates</h2>
            </div>
        </div> <!-- end row-->


        <div class="row g-4">
            <div class="col-lg-4">
                <article class="card rounded-3 border-0 shadow-sm">
                    <!-- Badge -->
                    <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Technology</div>

                    <!-- Card image -->
                    <img class="card-img-top rounded-top-3" src="/images/blog/blog-4.jpg" alt="Tech Innovations">

                    <!-- Card Body -->
                    <div class="card-body">
                        <!-- Title -->
                        <h6 class="card-title fs-lg lh-base mb-2">
                            <a href="article" class="link-reset">The Future of Artificial Intelligence</a>
                        </h6>
                        <p class="mb-3 text-muted">
                            Discover how AI is transforming industries and what the future holds for this cutting-edge technology.
                        </p>

                        <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                            <span><i class="ti ti-calendar fs-md"></i> Jan 12, 2025</span>
                            <span><i class="ti ti-message-circle fs-md"></i> <a href="#!" class="link-reset">89</a></span>
                            <span><i class="ti ti-eye fs-md"></i> 1,284</span>
                        </p>
                    </div>

                    <!-- Card footer -->
                    <div class="card-footer bg-transparent d-flex justify-content-between border-0">
                        <div class="d-flex justify-content-start align-items-center gap-2">
                            <div class="avatar avatar-xs">
                                <img src="/images/users/user-4.jpg" alt="avatar-4" class="img-fluid rounded-circle">
                            </div>
                            <div>
                                <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                    <a href="#!" class="link-reset">Michael Turner</a>
                                </h5>
                            </div>
                        </div>
                        <a class="link-primary fw-semibold" href="article">Read more <i class="ti ti-arrow-right"></i></a>
                    </div>
                </article>
            </div> <!-- end col-->

            <div class="col-lg-4">
                <article class="card rounded-3 border-0 shadow-sm">
                    <!-- Badge -->
                    <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Data Science</div>

                    <!-- Card image -->
                    <img class="card-img-top rounded-top-3" src="/images/blog/blog-5.jpg" alt="Data Science Trends">

                    <!-- Card Body -->
                    <div class="card-body">
                        <!-- Title -->
                        <h6 class="card-title fs-lg lh-base mb-2">
                            <a href="article" class="link-reset">Top Data Science Trends in 2025</a>
                        </h6>
                        <p class="mb-3 text-muted">
                            Get ahead in the data science field with the latest trends, technologies, and tools that are reshaping the industry.
                        </p>

                        <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                            <span><i class="ti ti-calendar fs-md"></i> Jan 12, 2025</span>
                            <span><i class="ti ti-message-circle fs-md"></i> <a href="#!" class="link-reset">89</a></span>
                            <span><i class="ti ti-eye fs-md"></i> 1,284</span>
                        </p>
                    </div>

                    <!-- Card footer -->
                    <div class="card-footer bg-transparent d-flex justify-content-between border-0">
                        <div class="d-flex justify-content-start align-items-center gap-2">
                            <div class="avatar avatar-xs">
                                <img src="/images/users/user-1.jpg" alt="avatar-1" class="img-fluid rounded-circle">
                            </div>
                            <div>
                                <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                    <a href="#!" class="link-reset">Olivia Brown</a>
                                </h5>
                            </div>
                        </div>
                        <a class="link-primary fw-semibold" href="article">Read more <i class="ti ti-arrow-right"></i></a>
                    </div>
                </article>
            </div> <!-- end col-->

            <div class="col-lg-4">
                <article class="card rounded-3 border-0 shadow-sm">
                    <!-- Badge -->
                    <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Business</div>

                    <!-- Card image -->
                    <img class="card-img-top rounded-top-3" src="/images/blog/blog-3.jpg" alt="Entrepreneur Tips">

                    <!-- Card Body -->
                    <div class="card-body">
                        <!-- Title -->
                        <h6 class="card-title fs-lg lh-base mb-2">
                            <a href="article" class="link-reset">5 Key Tips for New Entrepreneurs</a>
                        </h6>
                        <p class="mb-3 text-muted">
                            Start your entrepreneurial journey with these 5 essential tips that will guide you through the first year of business.
                        </p>

                        <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                            <span><i class="ti ti-calendar fs-md"></i> Jan 12, 2025</span>
                            <span><i class="ti ti-message-circle fs-md"></i> <a href="#!" class="link-reset">89</a></span>
                            <span><i class="ti ti-eye fs-md"></i> 1,284</span>
                        </p>
                    </div>

                    <!-- Card footer -->
                    <div class="card-footer bg-transparent d-flex justify-content-between border-0">
                        <div class="d-flex justify-content-start align-items-center gap-2">
                            <div class="avatar avatar-xs">
                                <img src="/images/users/user-7.jpg" alt="avatar-7" class="img-fluid rounded-circle">
                            </div>
                            <div>
                                <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                    <a href="#!" class="link-reset">David Clark</a>
                                </h5>
                            </div>
                        </div>
                        <a class="link-primary fw-semibold" href="article">Read more <i class="ti ti-arrow-right"></i></a>
                    </div>
                </article>
            </div> <!-- end col-->
        </div> <!-- end row-->
    </div> <!-- end container-->
</section>
<!-- =======================
    BLOG SECTION END
======================= -->

<!-- =======================
    CONTACT SECTION
======================= -->
<section class="section-custom" id="contact">

    <div class="container">

        <div class="row">
            <div class="col-12 text-center">
                <span class="text-muted rounded-3 d-inline-block">📞 We're Here to Help</span>
                <h2 class="mt-3 fw-bold mb-5">Get in Touch with <mark class="fst-italic">Our Team</mark></h2>
            </div>
        </div> <!-- end row-->

        <div class="row">
            <div class="col-xxl-4">
                <div class="p-4">
                    <div class="d-flex gap-3 mb-5">
                        <div class="avatar-xl flex-shrink-0">
                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                <i class="ti ti-phone-call"></i>
                            </span>
                        </div>
                        <div>
                            <span class="text-muted">Contact Numbers</span>
                            <h5 class="my-2">+1 (800) 123-4567</h5>
                            <h5 class="mb-0">+1 (415) 987-6543</h5>
                        </div>
                    </div>

                    <div class="d-flex gap-3 mb-5">
                        <div class="avatar-xl flex-shrink-0">
                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                <i class="ti ti-mail"></i>
                            </span>
                        </div>
                        <div>
                            <span class="text-muted">Email</span>
                            <h5 class="my-2">support@yourcompany.com</h5>
                            <h5 class="mb-0">info@yourcompany.com</h5>
                        </div>
                    </div>

                    <div class="d-flex gap-3">
                        <div class="avatar-xl flex-shrink-0">
                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                <i class="ti ti-map-pin"></i>
                            </span>
                        </div>
                        <div>
                            <span class="text-muted">Address</span>
                            <h5 class="my-1 lh-lg">INSPINIA HQ, 123 Market Street, 5th Floor, Financial District, San Francisco, CA 94103, United States</h5>
                        </div>
                    </div>
                </div> <!-- end .p-4-->
            </div> <!-- end col-->

            <div class="col-xxl-8">
                <form class="p-4 border rounded-4 border-dashed">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label">Full Name</label>
                            <input type="text" class="form-control py-2" id="name" autocomplete="name" placeholder="Enter your full name">
                        </div>

                        <div class="col-md-6">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="email" class="form-control py-2" id="email" autocomplete="email" placeholder="Enter your email">
                        </div>


                        <div class="col-md-12">
                            <label for="subject" class="form-label">Subject</label>
                            <input type="text" class="form-control py-2" id="subject" placeholder="What’s the reason for contact?">
                        </div>

                        <div class="col-md-12">
                            <label for="message" class="form-label">Message</label>
                            <textarea class="form-control py-2" id="message" rows="5" placeholder="Write your message here..."></textarea>
                        </div>

                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-primary rounded-pill">Send Message</button>
                        </div>
                    </div>
                </form>
            </div> <!-- end col-->
        </div> <!-- end row-->
    </div> <!-- end container-->
</section>
<!-- =======================
    CONTACT SECTION END
======================= -->

<!-- =======================
    FOOTER SECTION
======================= -->
<footer class="section-custom section-footer pb-2">

    <div class="container">
        <div class="row g-4 justify-content-between">
            <div class="col-lg-3">
                <img src="/images/logo-white.png" alt="logo" height="30">
                <p class="mt-3 fs-sm">INSPINIA is the top-selling admin dashboard template on WrapBootstrap, known for its sleek design, flexibility, and powerful features. Build modern web applications with ease using the best in class!</p>

                <div class="d-flex gap-2 mt-4 mb-2">
                    <a href="#!" class="btn btn-sm btn-icon rounded-circle btn-dark" title="Facebook">
                        <i data-lucide="facebook" class="fs-sm"></i>
                    </a>
                    <a href="#!" class="btn btn-sm btn-icon rounded-circle btn-dark" title="Twitter-x">
                        <i class="ti ti-brand-x fs-sm"></i>
                    </a>
                    <a href="#!" class="btn btn-sm btn-icon rounded-circle btn-dark" title="Instagram">
                        <i data-lucide="instagram" class="fs-sm"></i>
                    </a>
                    <a href="#!" class="btn btn-sm btn-icon rounded-circle btn-dark" title="WhatsApp">
                        <i data-lucide="dribbble" class="fs-sm"></i>
                    </a>
                </div>
            </div> <!-- end col-->

            <div class="col-lg-8 col-xxl-7">
                <div class="row g-4">
                    <div class="col-6 col-md-4">
                        <h5 class="text-white mb-4 ps-2">Company</h5>
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link pt-0" href="#!">Our Story</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Leadership Team</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Careers <span class="badge text-bg-warning ms-2">We're Hiring</span></a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Press & Media</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Investor Relations</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Sustainability</a></li>
                        </ul>
                    </div>

                    <div class="col-6 col-md-4">
                        <h5 class="text-white mb-4 ps-2">Community</h5>
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link pt-0" href="#!">Community Forum</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Events & Meetups</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Ambassadors</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Customer Stories</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Open Source</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Code of Conduct</a></li>
                        </ul>
                    </div>

                    <div class="col-6 col-md-4">
                        <h5 class="text-white mb-4 ps-2">Admin</h5>
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link pt-0" href="#!">Dashboard</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">User Management</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Roles & Permissions</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">System Logs</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">Settings</a></li>
                            <li class="nav-item"><a class="nav-link" href="#!">API Access</a></li>
                        </ul>
                    </div>
                </div> <!-- end row-->
            </div> <!-- end col-->
        </div> <!-- end row-->

        <div class="row mt-5">
            <div class="col-12 text-center">
                <p class="mb-4">© 2014 -
                    <script>document.write(new Date().getFullYear())</script> Inspinia By <span class="fw-semibold">WebAppLayers</span>
                </p>
            </div>
        </div> <!-- end row-->
    </div> <!-- end container-->
</footer>
<!-- =======================
    FOOTER SECTION END
======================= -->

@endsection

@section('scripts')
@vite(['resources/js/pages/landing.js'])
@endsection
