@extends('layouts.base', ['title' => 'Login with Pin'])

@section('content')

<div class="auth-box overflow-hidden align-items-center d-flex">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-4 col-md-6 col-sm-8">
                <div class="auth-brand text-center mb-4">
                    <a href="/" class="logo-dark">
                        <img src="/images/logo-black.png" alt="dark logo" height="32">
                    </a>
                    <a href="/" class="logo-light">
                        <img src="/images/logo.png" alt="logo" height="32">
                    </a>
                    <h4 class="fw-bold mt-3">Login with PIN! | IN+</h4>
                    <p class="text-muted w-lg-75 mx-auto">This screen is locked. Enter your PIN to continue.</p>
                </div>

                <div class="card p-4 rounded-4">
                    <div class="text-center mb-4">
                        <img src="/images/users/user-1.jpg" class="rounded-circle img-thumbnail avatar-xxl mb-2" alt="thumbnail">
                        <h5 class="fs-md">Damian D.</h5>
                    </div>

                    <form>
                        <label class="form-label">Enter your 6-digit code <span class="text-danger">*</span></label>
                        <div class="d-flex gap-2 mb-3 two-factor">
                            <input type="text" class="form-control text-center" required>
                            <input type="text" class="form-control text-center" required>
                            <input type="text" class="form-control text-center" required>
                            <input type="text" class="form-control text-center" required>
                            <input type="text" class="form-control text-center" required>
                            <input type="text" class="form-control text-center" required>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary fw-semibold py-2">Confirm</button>
                        </div>
                    </form>

                    <p class="text-muted text-center mt-4 mb-0">
                        Not you? Return to <a href="{{ route('second', ['auth1', 'login'])}}" class="text-decoration-underline link-offset-3 fw-semibold">Sign in</a>
                    </p>
                </div>

                <p class="text-center text-muted mt-4 mb-0">
                    © 2014 -
                    <script>document.write(new Date().getFullYear())</script> INSPINIA — by <span class="fw-semibold">WebAppLayers</span>
                </p>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
@vite(['resources/js/pages/auth-two-factor.js'])
@endsection
