import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                //js
                'resources/js/config.js',
                'resources/js/app.js',
                'resources/js/pages/dashboard.js',
                'resources/js/pages/apps-calendar.js',
                'resources/js/pages/apps-chat.js',
                'resources/js/pages/custom-table.js',
                'resources/js/pages/email-compose.js',
                'resources/js/pages/apps-kanban.js',
                'resources/js/pages/ecommerce-products.js',
                'resources/js/pages/ecommerce-add-product.js',
                'resources/js/pages/ecommerce-product-views.js',
                'resources/js/pages/ecommerce-seller-details.js',
                'resources/js/pages/ecommerce-reviews.js',
                'resources/js/pages/ecommerce-sales.js',
                'resources/js/pages/api-keys.js',
                'resources/js/maps/leaflet-data.js',
                'resources/js/pages/maps-leaflet.js',
                'resources/js/maps/world-merc.js',
                'resources/js/maps/world.js',
                'resources/js/maps/in-mill-en.js',
                'resources/js/maps/canada.js',
                'resources/js/maps/iraq.js',
                'resources/js/maps/russia.js',
                'resources/js/maps/spain.js',
                'resources/js/maps/us-aea-en.js',
                'resources/js/maps/us-lcc-en.js',
                'resources/js/maps/us-mill-en.js',
                'resources/js/pages/maps-vector.js',
                'resources/js/pages/flags-listing.js',
                'resources/js/pages/datatables-export-data.js',
                'resources/js/pages/form-colorpickr.js',
                'resources/js/pages/form-date-range-picker.js',
                'resources/js/pages/form-select2.js',
                'resources/js/pages/form-tagify.js',
                'resources/js/pages/form-choice.js',
                'resources/js/pages/form-wizard.js',
                'resources/js/pages/form-fileupload.js',
                'resources/js/pages/form-quilljs.js',                
                'resources/js/pages/form-range-slider.js',
                'resources/js/pages/form-inputmask.js',
                'resources/js/pages/form-typehead.js',
                'resources/js/pages/metrics.js',
                'resources/js/pages/chart-apexsankey.js',
                'resources/js/pages/chart-apextree.js',
                'resources/js/pages/chart-apex-area.js',
                'resources/js/pages/chart-apex-bar.js',
                'resources/js/pages/chart-apex-bubble.js',
                'resources/js/pages/chart-apex-candlestick.js',
                'resources/js/pages/chart-apex-funnel.js',
                'resources/js/pages/chart-apex-heatmap.js',
                'resources/js/pages/chart-apex-line.js',
                'resources/js/pages/chart-apex-mixed.js',
                'resources/js/pages/chart-apex-pie.js',
                'resources/js/pages/chart-apex-polar-area.js',
                'resources/js/pages/chart-apex-radar.js',
                'resources/js/pages/chart-apex-radialbar.js',
                'resources/js/pages/chart-apex-range.js',
                'resources/js/pages/chart-apex-scatter.js',
                'resources/js/pages/chart-apex-slope.js',
                'resources/js/pages/chart-apex-sparklines.js',
                'resources/js/pages/chart-apex-timeline.js',
                'resources/js/pages/chart-apex-treemap.js',
                'resources/js/pages/chart-apex-boxplot.js',
                'resources/js/pages/chart-apex-column.js',
                'resources/js/pages/chart-echart-scatter.js',
                'resources/js/pages/chart-echart-area.js',
                'resources/js/pages/chart-echart-bar.js',
                'resources/js/pages/chart-echart-candlestick.js',
                'resources/js/pages/chart-echart-gauge.js',
                'resources/js/pages/chart-echart-geo-map.js',
                'resources/js/pages/chart-echart-heatmap.js',
                'resources/js/pages/chart-echart-line.js',
                'resources/js/pages/chart-echart-other.js',
                'resources/js/pages/chart-echart-pie.js',
                'resources/js/pages/chart-echart-radar.js',
                'resources/js/pages/chart-echart-scatter.js',
                'resources/js/pages/coming-soon.js',
                'resources/js/pages/misc-nestable.js',
                'resources/js/pages/misc-text-diff.js',
                'resources/js/pages/misc-pdf-viewer.js',
                'resources/js/pages/misc-sweetalerts.js',
                'resources/js/pages/misc-idle-timer.js',
                'resources/js/pages/misc-pass-meter.js',
                'resources/js/pages/misc-tinycon.js',
                'resources/js/pages/misc-clipboard.js',
                'resources/js/pages/misc-treeview.js',
                'resources/js/pages/misc-loading-button.js',
                'resources/js/pages/misc-gallery.js',
                'resources/js/pages/misc-tour.js',
                'resources/js/pages/misc-animation.js',
                'resources/js/maps/world.js',
                'resources/js/pages/dashboard-2.js',
                'resources/js/pages/dashboard-3.js',                                
                'resources/js/pages/auth-password.js',
                'resources/js/pages/auth-two-factor.js',
                'resources/js/pages/landing.js',
                'resources/js/pages/basic-datatable.js',
                'resources/js/pages/datatables-add-rows.js',
                'resources/js/pages/datatables-ajax.js',
                'resources/js/pages/datatables-checkbox-select.js',
                'resources/js/pages/datatables-child-rows.js',
                'resources/js/pages/datatables-column-search.js',
                'resources/js/pages/datatables-fixed-header.js',
                'resources/js/pages/datatables-javascript-source.js',
                'resources/js/pages/datatables-range-search.js',
                'resources/js/pages/datatables-rendering.js',
                'resources/js/pages/datatables-scroll.js',
                'resources/js/pages/datatables-select.js',
                'resources/js/pages/datatables-show-hide-columns.js',
                'resources/js/pages/ui-notifications.js',

                //css
                'resources/scss/app.scss',
                'node_modules/quill/dist/quill.core.css',
                'node_modules/quill/dist/quill.snow.css',
                'node_modules/quill/dist/quill.bubble.css',
                'node_modules/flatpickr/dist/flatpickr.min.css',
                'node_modules/nouislider/dist/nouislider.min.css',
                'node_modules/@tabler/icons-webfont/dist/tabler-icons.min.css',
                'node_modules/dropzone/dist/dropzone.css',
                'node_modules/leaflet/dist/leaflet.css',
                'node_modules/jsvectormap/dist/jsvectormap.min.css',
                'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
                'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
                'node_modules/daterangepicker/daterangepicker.css',
                'node_modules/@simonwep/pickr/dist/themes/classic.min.css',
                'node_modules/@simonwep/pickr/dist/themes/monolith.min.css',
                'node_modules/@simonwep/pickr/dist/themes/nano.min.css',                
                'node_modules/choices.js/public/assets/styles/choices.min.css',
                'node_modules/select2/dist/css/select2.min.css',
                'node_modules/dropzone/dist/dropzone.css',
                'node_modules/filepond/dist/filepond.min.css',
                'node_modules/filepond-plugin-image-preview/dist/filepond-plugin-image-preview.min.css',
                'node_modules/summernote/dist/summernote-bs5.min.css',
                'node_modules/jstree/dist/themes/default/style.min.css',
                'node_modules/ladda/dist/ladda.min.css',
                'node_modules/glightbox/dist/css/glightbox.min.css',
                'node_modules/@sjmc11/tourguidejs/dist/css/tour.min.css',
                'node_modules/animate.css/animate.min.css',
                'node_modules/jsvectormap/dist/jsvectormap.min.css',
                'node_modules/flatpickr/dist/flatpickr.min.css',                
                'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',                
                'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',                
                'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
                'node_modules/spinkit/spinkit.min.css',
                'node_modules/ladda/dist/ladda-themeless.min.css'                
            ],
            refresh: true,
        }),
    ],
});
