<?php $__env->startSection('content'); ?>

<div class="auth-box overflow-hidden align-items-center d-flex">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-4 col-md-6 col-sm-8">
                <div class="auth-brand text-center mb-4">
                    <a href="<?php echo e(route('second', ['dashboards', 'index'])); ?>" class="logo-dark">
                        <img src="/images/logo-black.png" alt="dark logo" height="32">
                    </a>
                    <a href="<?php echo e(route('second', ['dashboards', 'index'])); ?>" class="logo-light">
                        <img src="/images/logo.png" alt="logo" height="32">
                    </a>
                    <h4 class="fw-bold mt-3">Register to IN+</h4>
                    <p class="text-muted w-lg-75 mx-auto">Let’s get you started. Create your account by entering your details below.</p>
                </div>

                <div class="card p-4 rounded-4">
                    <form method="POST" action="<?php echo e(route('register')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="name" name="name" placeholder="Damian D." required>
                            </div>
                            <?php if($errors->get('name')): ?>
                                <ul class="list-unstyled ps-0 mt-1">
                                    <?php $__currentLoopData = (array) $errors->get('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-danger mb-1"><?php echo e($message); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email address <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="email" class="form-control" id="email" name="email" placeholder="you@example.com" required>
                            </div>
                            <?php if($errors->get('email')): ?>
                                <ul class="list-unstyled ps-0 mt-1">
                                    <?php $__currentLoopData = (array) $errors->get('email'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-danger mb-1"><?php echo e($message); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3" data-password="bar">
                            <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="password" class="form-control" id="password" name="password" placeholder="••••••••" required>
                            </div>
                            <div class="password-bar my-2"></div>
                            <p class="text-muted fs-xs mb-0">Use 8+ characters with letters, numbers & symbols.</p>
                            <?php if($errors->get('password')): ?>
                                <ul class="list-unstyled ps-0 mt-1">
                                    <?php $__currentLoopData = (array) $errors->get('password'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-danger mb-1"><?php echo e($message); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="confirm-password" class="form-label">Confirm Password <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="password" class="form-control" id="confirm-password" name="password_confirmation" placeholder="••••••••" required>
                            </div>
                            <?php if($errors->get('password_confirmation')): ?>
                                <ul class="list-unstyled ps-0 mt-1">
                                    <?php $__currentLoopData = (array) $errors->get('password_confirmation'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-danger mb-1"><?php echo e($message); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input form-check-input-light fs-14" type="checkbox" id="termAndPolicy">
                                <label class="form-check-label" for="termAndPolicy">Agree the Terms & Policy</label>
                            </div>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary fw-semibold py-2">Create Account</button>
                        </div>
                    </form>

                    <p class="text-muted text-center mt-4 mb-0">
                        Already have an account? <a href="<?php echo e(route('login')); ?>" class="text-decoration-underline link-offset-3 fw-semibold">Login</a>
                    </p>
                </div>

                <p class="text-center text-muted mt-4 mb-0">
                    © 2014 -
                    <script>document.write(new Date().getFullYear())</script> INSPINIA — by <span class="fw-semibold">WebAppLayers</span>
                </p>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/js/pages/auth-password.js']); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', ['title' => 'Create New Account'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/parthiv/Desktop/Inspinia_Laravel/Inspinia_Laravel/resources/views/auth1/register.blade.php ENDPATH**/ ?>