<?= $this->include('./partials/html') ?>

    <head>
        <?php echo view("partials/title-meta", array("title" => "Password Meter")) ?>

        <?= $this->include('./partials/head-css') ?>
    </head>

    <body>
        <!-- Begin page -->
        <div class="wrapper">

            <?= $this->include('./partials/menu') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->

            <div class="content-page">

                <div class="container-fluid">

                    <?php echo view("./partials/page-title", array("subtitle" => "Miscellaneous", "title" => "Password Meter")) ?>

                    <div class="row justify-content-center">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">with Progress Bar</h4>

                                    <div class="card-action">
                                        <a href="#!" class="card-action-item" data-action="card-toggle"><i class="ti ti-chevron-up"></i></a>
                                        <a href="#!" class="card-action-item" data-action="code-collapse"><i class="ti ti-code"></i></a>
                                    </div>
                                </div><!-- end card header -->

                                <div class="code-body">
                                    <pre>
                                        <code class="language-markup">
                                            &lt;!-- HTML --&gt;
                                            &lt;input type=&quot;password&quot; class=&quot;form-control mb-2&quot; placeholder=&quot;Password&quot; /&gt;

                                            &lt;div class=&quot;password-bar mb-2&quot;&lt;/div&gt;

                                            &lt;!-- Find Javascript in File: /js/pages/misc-pass-meter.js --&gt;
                                        </code>
                                    </pre> <!-- end highlight-->
                                </div> <!-- end preview code-->

                                <div class="card-body">
                                    <!-- HTML -->
                                    <input type="password" class="form-control mb-2" placeholder="Password">
                                    <div class="password-bar mb-2"></div>

                                    <p class="text-muted fs-xs mb-0">Use 8 or more characters with a mix of letters, numbers & symbols.</p>
                                </div>
                            </div><!-- end card-body -->
                        </div><!-- end card -->

                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">with Password Condition</h4>

                                    <div class="card-action">
                                        <a href="#!" class="card-action-item" data-action="card-toggle"><i class="ti ti-chevron-up"></i></a>
                                        <a href="#!" class="card-action-item" data-action="code-collapse"><i class="ti ti-code"></i></a>
                                    </div>
                                </div><!-- end card header -->

                                <div class="code-body">
                                    <pre>
                                        <code class="language-markup">
                                            &lt;!-- HTML --&gt;
                                            &lt;div&gt;
                                                &lt;label class=&quot;form-label&quot; for=&quot;password-input&quot;&gt;Magic Password ✨ (Click Here)&lt;/label&gt;
                                                &lt;input type=&quot;password&quot; class=&quot;form-control&quot; placeholder=&quot;Enter password&quot; id=&quot;password-input&quot; pattern=&quot;(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}&quot;&gt;

                                                &lt;div class=&quot;form-text&quot;&gt;Use 8 or more characters with a mix of letters, numbers &amp; symbols.&lt;/div&gt;

                                                &lt;div class=&quot;password-box collapse bg-light-subtle border border-light mt-2 rounded&quot;&gt;
                                                    &lt;div class=&quot;p-3&quot;&gt;
                                                        &lt;h5 class=&quot;fs-sm mb-2&quot;&gt;Password Recipe:&lt;/h5&gt;
                                                        &lt;p id=&quot;pass-length&quot; class=&quot;invalid fs-xs mb-2&quot;&gt;Minimum &lt;b&gt;8 characters&lt;/b&gt;&lt;/p&gt;
                                                        &lt;p id=&quot;pass-lower&quot; class=&quot;invalid fs-xs mb-2&quot;&gt;At &lt;b&gt;lowercase&lt;/b&gt; letter (a-z)&lt;/p&gt;
                                                        &lt;p id=&quot;pass-upper&quot; class=&quot;invalid fs-xs mb-2&quot;&gt;At least &lt;b&gt;uppercase&lt;/b&gt; letter (A-Z)&lt;/p&gt;
                                                        &lt;p id=&quot;pass-number&quot; class=&quot;invalid fs-xs mb-0&quot;&gt;A least &lt;b&gt;number&lt;/b&gt; (0-9)&lt;/p&gt;
                                                    &lt;/div&gt;
                                                &lt;/div&gt;
                                            &lt;/div&gt;

                                            &lt;!-- Find Javascript in File: /js/pages/misc-pass-meter.js --&gt;
                                        </code>
                                    </pre> <!-- end highlight-->
                                </div> <!-- end preview code-->

                                <div class="card-body">

                                    <!-- HTML -->
                                    <div>
                                        <label class="form-label" for="password-input">Magic Password ✨ (Click Here)</label>
                                        <input type="password" class="form-control" placeholder="Enter password" id="password-input" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}">

                                        <div class="form-text">Use 8 or more characters with a mix of letters, numbers & symbols.</div>

                                        <div class="password-box collapse bg-light-subtle border border-light mt-2 rounded">
                                            <div class="p-3">
                                                <h5 class="fs-sm mb-2">Password Recipe:</h5>
                                                <p id="pass-length" class="invalid fs-xs mb-2">Minimum <b>8 characters</b></p>
                                                <p id="pass-lower" class="invalid fs-xs mb-2">At <b>lowercase</b> letter (a-z)</p>
                                                <p id="pass-upper" class="invalid fs-xs mb-2">At least <b>uppercase</b> letter (A-Z)</p>
                                                <p id="pass-number" class="invalid fs-xs mb-0">A least <b>number</b> (0-9)</p>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div><!-- end card-body -->
                        </div><!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

                <?= $this->include('./partials/footer') ?>

            </div>

            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <?= $this->include('./partials/customizer') ?>

        <?= $this->include('./partials/footer-scripts') ?>

        <script src="/js/pages/misc-pass-meter.js"></script>

    </body>

</html>