<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->element('title_meta', ['title' => 'Terms & Conditions']) ?>

    <?= $this->element('head_css') ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?= $this->element('menu') ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">

            <div class="container-fluid">

                <?= $this->element('page_title', ['subtitle' => 'Pages', 'title' => 'Terms & Conditions']) ?>

                <div class="row justify-content-center">
                    <div class="col-xxl-8">
                        <div class="text-center my-4">
                            <h1 class="fw-bold">Terms & Conditions</h1>
                            <p class="text-muted">Effective Date: April 19, 2025</p>
                        </div>

                        <div class="card position-relative">
                            <div class="position-absolute top-0 end-0">
                                <svg style="opacity: 0.05;" width="600" height="560" viewBox="0 0 600 560" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <!-- Circle -->
                                    <circle cx="550" cy="80" r="40" fill="#ed5565" />

                                    <!-- Wavy Path -->
                                    <path d="M460 120 C470 90, 500 90, 510 120 S550 150, 560 120" stroke="#1c84c6" stroke-width="2" fill="none" />

                                    <!-- Triangle -->
                                    <path d="M400 200 L450 150 L500 200 Z" fill="#f8ac59" />

                                    <!-- Oval -->
                                    <ellipse cx="520" cy="280" rx="30" ry="50" fill="#6b5eae" />

                                    <!-- Rounded Diamond -->
                                    <path d="M360 320 Q370 300 390 310 Q410 320 400 340 Q390 360 370 350 Q350 340 360 320 Z" fill="#1ab394" />

                                    <!-- Organic blob -->
                                    <path d="M470 400 C460 380, 490 370, 510 380 C530 390, 540 410, 520 430 C500 450, 480 440, 470 400 Z" fill="#ff679b" />

                                    <!-- Star -->
                                    <path d="M380 80 L388 100 H410 L392 115 L400 135 L380 123 L360 135 L368 115 L350 100 H372 Z" fill="#0acf97" />

                                    <!-- Spiral -->
                                    <path d="M290 100 C300 90, 310 110, 300 120 C290 130, 270 130, 260 120 C250 110, 250 90, 260 80" stroke="#23c6c8" stroke-width="2" fill="none" />

                                    <!-- Custom Polygon (Irregular Shape) -->
                                    <path d="M320 200 L330 210 L320 230 L300 230 L290 210 Z" fill="#fd7e14" />

                                    <!-- Ring -->
                                    <circle cx="460" cy="250" r="20" stroke="#1c84c6" stroke-width="3" fill="none" />
                                </svg>
                            </div>
                            <div class="position-absolute bottom-0 start-0">
                                <svg style="opacity: 0.05;" width="600" height="560" viewBox="0 0 600 560" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <!-- Circle -->
                                    <circle cx="50" cy="480" r="40" fill="#FF4C3E" />

                                    <!-- Wavy Path -->
                                    <path d="M140 440 C130 470, 100 470, 90 440 S50 410, 40 440" stroke="#089df1" stroke-width="2" fill="none" />

                                    <!-- Triangle -->
                                    <path d="M100 360 L50 410 L0 360 Z" fill="#f9bf59" />

                                    <!-- Oval -->
                                    <ellipse cx="80" cy="280" rx="30" ry="50" fill="#7b70ef" />

                                    <!-- Rounded Diamond -->
                                    <path d="M140 240 Q130 260 110 250 Q90 240 100 220 Q110 200 130 210 Q150 220 140 240 Z" fill="#089df1" />

                                    <!-- Organic blob -->
                                    <path d="M130 150 C140 170, 110 180, 90 170 C70 160, 60 140, 80 120 C100 100, 120 110, 130 150 Z" fill="#f7577e" />

                                    <!-- Star -->
                                    <path d="M220 480 L212 460 H190 L208 445 L200 425 L220 437 L240 425 L232 445 L250 460 H228 Z" fill="#7b70ef" />

                                    <!-- Spiral -->
                                    <path d="M310 460 C300 470, 290 450, 300 440 C310 430, 330 430, 340 440 C350 450, 350 470, 340 480" stroke="#089df1" stroke-width="2" fill="none" />

                                    <!-- Custom Polygon (Irregular Shape) -->
                                    <path d="M280 360 L270 350 L280 330 L300 330 L310 350 Z" fill="#f7577e" />

                                    <!-- Ring -->
                                    <circle cx="140" cy="310" r="20" stroke="#089df1" stroke-width="3" fill="none" />
                                </svg>
                            </div>

                            <div class="card-body position-relative">
                                <p class="fst-italic fs-sm">Welcome to our website. By accessing or using this site, you agree to be bound by these terms and conditions. Please read them carefully.</p>

                                <h4 class="fw-bold mt-3">1. Acceptance of Terms</h4>
                                <p>By using this website, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions. If you do not agree, please do not use our services.</p>

                                <h4 class="fw-bold mt-4">2. Modifications</h4>
                                <p>We reserve the right to modify these Terms and Conditions at any time. Updated terms will be posted on this page with the revised date. Continued use constitutes acceptance of any changes.</p>

                                <h4 class="fw-bold mt-4">3. Intellectual Property</h4>
                                <p>All content, trademarks, graphics, and materials on this website are owned or licensed by us and protected by copyright and intellectual property laws. Unauthorized use is strictly prohibited.</p>

                                <h4 class="fw-bold mt-4">4. User Responsibilities</h4>
                                <ul>
                                    <li>Do not engage in unauthorized copying or distribution.</li>
                                    <li>Do not use the site for illegal or unauthorized purposes.</li>
                                    <li>Do not attempt to gain unauthorized access to the website or its data.</li>
                                </ul>

                                <h4 class="fw-bold mt-4">5. Payment and Refunds</h4>
                                <p>All purchases are final unless otherwise specified. Refund requests will be considered on a case-by-case basis. Licensing fees may vary based on usage.</p>

                                <h4 class="fw-bold mt-4">6. Limitation of Liability</h4>
                                <p>We are not liable for any indirect, incidental, or consequential damages arising from the use of our products or services.</p>

                                <h4 class="fw-bold mt-4">7. License Types</h4>

                                <h5 class="mt-3">Single License</h5>
                                <ul class="lh-lg">
                                    <li>Restricted to a single installation.</li>
                                    <li>For use in personal or client work.</li>
                                    <li>Not for redistribution or resale.</li>
                                    <li>GPL terms override where applicable.</li>
                                </ul>

                                <h5 class="mt-3">Multiple License</h5>
                                <ul class="lh-lg">
                                    <li>Permits multiple installations.</li>
                                    <li>For use in multiple personal or client projects.</li>
                                    <li>Not for resale or redistribution.</li>
                                    <li>GPL terms override where applicable.</li>
                                </ul>

                                <h5 class="mt-3">Extended License</h5>
                                <ul class="lh-lg">
                                    <li>Permits resale or redistribution as part of a larger work.</li>
                                    <li>Allowed in modified or integrated final products.</li>
                                    <li>Licensed components must not be used standalone.</li>
                                    <li>GPL terms override where applicable.</li>
                                </ul>

                                <h4 class="fw-bold mt-4">8. Termination</h4>
                                <p>We reserve the right to terminate access to our services if you violate any terms.</p>

                                <h4 class="fw-bold mt-4">9. Governing Law</h4>
                                <p>These Terms are governed by and construed in accordance with the laws of the applicable jurisdiction.</p>

                                <p class="mt-4 mb-0">For any questions regarding these Terms, please contact us at <a href="mailto:support@example.com">support@example.com</a>.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container -->

            <?= $this->element('footer') ?>

        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?= $this->element('customizer') ?>

    <?= $this->element('footer_scripts') ?>

</body>

</html>