import { Component } from '@angular/core';
import { UiCardComponent } from "@app/components/ui-card.component";

@Component({
    selector: 'app-about',
    imports: [UiCardComponent],
    template: `
 <app-ui-card title="About Me">
         <div  card-body>
                    <p>I'm a Product Designer and template author passionate about crafting clean, scalable, and
                        high-performing UI solutions. With a focus on frontend technologies and modern design
                        systems, I create user-centric digital products that are both functional and visually
                        appealing.</p>
                    <p class="mb-0">As a template creator, I specialize in building developer-friendly UI kits
                        and dashboards using frameworks like Tailwind CSS, Bootstrap, React, Next.js, Vue, and
                        Laravel. My work powers countless web apps, helping developers save time and build
                        faster.</p>

                    <div class="mt-3">
                        <h5 class="mb-2">My Approach :</h5>
                        <p class="mb-0">I take a user-first approach to design—blending thoughtful UX with clean
                            code. From wireframes to fully responsive templates, I focus on creating intuitive
                            and aesthetic experiences. Whether you're launching a SaaS dashboard, admin panel,
                            or marketing site, I strive to deliver pixel-perfect results that elevate your
                            product.</p>
                    </div>
                </div>
 </app-ui-card>
  `,
    styles: ``
})
export class AboutComponent {

}
